#!/bin/sh
#
# $Id$
#
# Copyright (c) 2005, 2006 Freie Universitaet Berlin.
# All rights reserved.
#
# Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

for f in "autoheader260" "autoheader259" "autoheader"; do
	which $f >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		AUTOHEADER="${f}"
		break
	fi
done

for f in "aclocal-1.9" "aclocal19" "aclocal"; do
	which $f >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		ACLOCAL="${f}"
		break
	fi
done

for f in "autoconf260" "autoconf259" "autoconf"; do
	which $f >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		AUTOCONF="${f}"
		break
	fi
done

for f in "automake-1.9" "automake19" "automake"; do
	which $f >/dev/null 2>&1
	if [ $? -eq 0 ]; then
		AUTOMAKE="${f} -a -c"
		break
	fi
done

if [ -z "${AUTOHEADER}" -o -z "${ACLOCAL}" -o \
     -z "${AUTOCONF}" -o -z "${AUTOMAKE}" ]; then
	echo "$0: cannot find (all) GNU autotools, aborting." >&2
	exit 1
fi

echo "Running GNU autotools:"
echo "* ${AUTOHEADER}" ; ${AUTOHEADER}
echo "* ${ACLOCAL}"    ; ${ACLOCAL} 2>/dev/null
echo "* ${AUTOCONF}"   ; ${AUTOCONF}
echo "* ${AUTOMAKE}"   ; ${AUTOMAKE}

rm -rf "autom4te.cache" "config.h.in~"
exit 0
