/*
 * $Id$
 *
 * Copyright (c) 2005, 2006 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif			/* HAVE_SYS_TYPES_H */
#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif			/* HAVE_SYS_WAIT_H */
#include <stdlib.h>

#include "command.h"
#include "log.h"
#include "zupsd.h"

RCSID("$Id$");

int
run(const char *command)
{
	int status, code;

	if (!system(NULL)) {
		error("cannot run '%s': sh(1) not available", command);
		return -1;
	}
	if ((status = system(command)) == -1) {
		error("fork(2)ing sh(1) or waiting for command '%s' failed: %m",
		    command);
		return -1;
	}
	if (WIFSIGNALED(status)) {
		error("command '%s' received signal %d", command,
		    WTERMSIG(status));
		return -1;
	}
	if (WIFEXITED(status)) {
		code = WEXITSTATUS(status);
		if (code == 126) {
			/* assume 126 was returned by sh(1), not command */
			error("command '%s': permission denied", command);
			return -1;
		}
		if (code == 127) {
			/* assume 127 was returned by sh(1), not command */
			error("command '%s': not found", command);
			return -1;
		}
		debug("command '%s' returned exit code %d", command, code);
		return code;
	}

	error("exit status of command '%s' unknown", command);
	return -1;
}
