/*
 * $Id$
 *
 * Copyright (c) 2005, 2006 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CONF_H
#define CONF_H

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#define MAXLINELEN 1024

#include "zupsd.h"	/* bool type */

typedef signed char   conf_boo_t;
typedef        long   conf_int_t;
typedef        char * conf_str_t;

typedef struct {
	const char *name;
	const unsigned char key;
	const unsigned char type;
	const char *dflt;
} keyword;

typedef struct module {
	struct module *next;
	unsigned char type;
	void *config;
	int (*test)(void *config);
	int (*check)(void *config);
	/* used in conf.c only */
	const keyword *keywords;
} module;

typedef struct {
	/* user configuration */
	conf_int_t check_interval;
	conf_int_t debug_level;
	conf_int_t max_shutdowns;
	conf_int_t num_alert;
	conf_int_t num_critical;
	conf_str_t hostsfile;
	conf_str_t pidfile;
	conf_str_t shutdown_cmd;
	conf_str_t suicide_cmd;
	conf_str_t syslog_facility;
	conf_boo_t commit_suicide;
	/* global ups module defaults */
	conf_int_t alert_threshold;
	conf_int_t email_infolevel;
	conf_int_t pager_infolevel;
	conf_int_t retries;
	conf_int_t timeout;
	conf_str_t hostname;	/* also used for plugin modules */
	conf_str_t community;
	conf_str_t email_contact;
	conf_str_t pager_contact;
	conf_str_t email_cmd;
	conf_str_t pager_cmd;
	/* global plugin module defaults */
	conf_str_t check_cmd;
	conf_str_t test_cmd;
} general_conf;

typedef struct {
	/* user configuration */
	conf_int_t alert_threshold;
	conf_int_t email_infolevel;
	conf_int_t pager_infolevel;
	conf_int_t retries;
	conf_int_t timeout;
	conf_str_t hostname;
	conf_str_t community;
	conf_str_t email_contact;
	conf_str_t pager_contact;
	conf_str_t email_cmd;
	conf_str_t pager_cmd;
	/* for internal use */
	int notified_by_email;
	int notified_by_pager;
} ups_conf;

typedef struct {
	/* user configuration */
	conf_str_t hostname;
	conf_str_t check_cmd;
	conf_str_t test_cmd;
} plugin_conf;

module *readconf(const char *file);
void free_modules(module *modules);

#endif			/* CONF_H */
