/*
 * $Id$
 *
 * Copyright (c) 2005, 2006 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef LOG_H
#define LOG_H

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#if HAVE_STDARG_H
#include <stdarg.h>
#endif			/* HAVE_STDARG_H */
#include <syslog.h>

#include "zupsd.h"	/* bool */

#define ZUPSD_SYSLOG 0x01
#define ZUPSD_STDERR 0x02

extern int debugging;

void open_log(const char *ident, int facility, int output);
void close_log(void);
void reopen_log(const char *ident, int facility, int output);
int str2facility(const char *facility);

#if HAVE_STDARG_H

#if (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L) \
    || (defined(__SUNPRO_C) && __SUNPRO_C >= 0x420)

#define USE_LOG_MACROS 1

#define debug(...)                                                             \
	do {                                                                   \
		if (!debugging)                                                \
			break;                                                 \
		else if (debugging > 1)                                        \
			_log(__FILE__, __LINE__, LOG_DEBUG, __VA_ARGS__);      \
		else                                                           \
			_log(NULL, 0, LOG_DEBUG, __VA_ARGS__);                 \
	} while (/* CONSTCOND */ 0)

#define info(...)                                                              \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_INFO, __VA_ARGS__);       \
		else                                                           \
			_log(NULL, 0, LOG_INFO, __VA_ARGS__);                  \
	} while (/* CONSTCOND */ 0)

#define notice(...)                                                            \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_NOTICE, __VA_ARGS__);     \
		else                                                           \
			_log(NULL, 0, LOG_NOTICE, __VA_ARGS__);                \
	} while (/* CONSTCOND */ 0)

#define warn(...)                                                              \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_WARNING, __VA_ARGS__);    \
		else                                                           \
			_log(NULL, 0, LOG_WARNING, __VA_ARGS__);               \
	} while (/* CONSTCOND */ 0)

#define error(...)                                                             \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_ERR, __VA_ARGS__);        \
		else                                                           \
			_log(NULL, 0, LOG_ERR, __VA_ARGS__);                   \
	} while (/* CONSTCOND */ 0)

#define crit(...)                                                              \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_CRIT, __VA_ARGS__);       \
		else                                                           \
			_log(NULL, 0, LOG_CRIT, __VA_ARGS__);                  \
	} while (/* CONSTCOND */ 0)

#define alert(...)                                                             \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_ALERT, __VA_ARGS__);      \
		else                                                           \
			_log(NULL, 0, LOG_ALERT, __VA_ARGS__);                 \
	} while (/* CONSTCOND */ 0)

/*
 * I don't know which GNU cpp version introduced the ##args syntax.  GCC 2.95.4
 * works, 2.5.8 doesn't, but checking for GCC >= 2.9 is a pure guess.  Anyone?
 */
#elif defined(__GNUC__) && (__GNUC__ >= 3 || ( __GNUC__ == 2 &&                \
    __GNUC_MINOR__ >= 9))

#define USE_LOG_MACROS 1

#define debug(fmt, args...)                                                    \
	do {                                                                   \
		if (!debugging)                                                \
			break;                                                 \
		else if (debugging > 1)                                        \
			_log(__FILE__, __LINE__, LOG_DEBUG, fmt , ##args);     \
		else                                                           \
			_log(NULL, 0, LOG_DEBUG, fmt , ##args);                \
	} while (/* CONSTCOND */ 0)

#define info(fmt, args...)                                                     \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_INFO, fmt , ##args);      \
		else                                                           \
			_log(NULL, 0, LOG_INFO, fmt , ##args);                 \
	} while (/* CONSTCOND */ 0)

#define notice(fmt, args...)                                                   \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_NOTICE, fmt , ##args);    \
		else                                                           \
			_log(NULL, 0, LOG_NOTICE, fmt , ##args);               \
	} while (/* CONSTCOND */ 0)

#define warn(fmt, args...)                                                     \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_WARNING, fmt , ##args);   \
		else                                                           \
			_log(NULL, 0, LOG_WARNING, fmt , ##args);              \
	} while (/* CONSTCOND */ 0)

#define error(fmt, args...)                                                    \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_ERR, fmt , ##args);       \
		else                                                           \
			_log(NULL, 0, LOG_ERR, fmt , ##args);                  \
	} while (/* CONSTCOND */ 0)

#define crit(fmt, args...)                                                     \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_CRIT, fmt , ##args);      \
		else                                                           \
			_log(NULL, 0, LOG_CRIT, fmt , ##args);                 \
	} while (/* CONSTCOND */ 0)

#define alert(fmt, args...)                                                    \
	do {                                                                   \
		if (debugging > 1)                                             \
			_log(__FILE__, __LINE__, LOG_ALERT, fmt , ##args);     \
		else                                                           \
			_log(NULL, 0, LOG_ALERT, fmt , ##args);                \
	} while (/* CONSTCOND */ 0)

#endif			/* __STDC_VERSION__ >= 199901L */

#if USE_LOG_MACROS
void _log(const char *file, int line, int pri, const char *fmt, ...);
#else
void debug(const char *fmt, ...);
void info(const char *fmt, ...);
void notice(const char *fmt, ...);
void warn(const char *fmt, ...);
void error(const char *fmt, ...);
void crit(const char *fmt, ...);
void alert(const char *fmt, ...);
#endif

#else
#error "cannot implement variable number of arguments on your platform"
#endif			/* HAVE_STDARG_H */

#endif			/* LOG_H */
