/*
 * $Id$
 *
 * Copyright (c) 2005, 2006 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#include <stdlib.h>

#include "command.h"
#include "conf.h"
#include "log.h"
#include "plugin.h"
#include "text.h"
#include "zupsd.h"

RCSID("$Id$");

static inline int run_plugin(conf_str_t command, conf_str_t hostname);

int
plugin_test(void *config)
{
	plugin_conf *plugin = (plugin_conf *) config;

	return run_plugin(plugin->test_cmd, plugin->hostname);
}

int
plugin_check(void *config)
{
	plugin_conf *plugin = (plugin_conf *) config;

	return run_plugin(plugin->check_cmd, plugin->hostname);
}

static inline int
run_plugin(conf_str_t command, conf_str_t hostname)
{
	int status;
	char *cmd;

	if ((cmd = replace(command, "%h", hostname)) == NULL)
		return MODULE_UNKNOWN;

	debug("running plugin command '%s'", cmd);

	switch ((status = run(cmd))) {
	case MODULE_OK:       /* FALLTHROUGH */
	case MODULE_UNKNOWN:  /* FALLTHROUGH */
	case MODULE_WARNING:  /* FALLTHROUGH */
	case MODULE_CRITICAL: /* FALLTHROUGH */
	case MODULE_ALERT:
		break;
	case -1:
		/* error logged by run() */
		status = MODULE_UNKNOWN;
		break;
	default:
		error("plugin command '%s' returned unknown status %d", cmd,
		    status);
		status = MODULE_UNKNOWN;
	}

	free(cmd);
	return status;
}
