/*
 * $Id$
 *
 * Copyright (c) 2005, 2006 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#include <signal.h>
#include <string.h>

#include "log.h"
#include "sig.h"
#include "zupsd.h"

RCSID("$Id$");

void
block_signals(bool block)
{
	static sigset_t sigs, oldsigs;

	if (block) {
		(void) sigfillset(&sigs);
		(void) sigprocmask(SIG_BLOCK, &sigs, &oldsigs);
		debug("blocking all signals");
	} else {
		/*
		 * Make sure SIGUSR1 and SIGUSR2 are unblocked regardless of
		 * oldsigs.
		 */
		if (sigismember(&oldsigs, SIGUSR1))
			(void) sigdelset(&oldsigs, SIGUSR1);
		if (sigismember(&oldsigs, SIGUSR2))
			(void) sigdelset(&oldsigs, SIGUSR2);
		(void) sigprocmask(SIG_SETMASK, &oldsigs, NULL);
		debug("restoring signal mask");
	}
}

const char *
signal2str(int sig)
{
	static const map signames[] = {
#ifdef SIGHUP
		{ "SIGHUP",    SIGHUP,    },
#endif
#ifdef SIGINT
		{ "SIGINT",    SIGINT,    },
#endif
#ifdef SIGQUIT
		{ "SIGQUIT",   SIGQUIT,   },
#endif
#ifdef SIGILL
		{ "SIGILL",    SIGILL,    },
#endif
#ifdef SIGTRAP
		{ "SIGTRAP",   SIGTRAP,   },
#endif
#ifdef SIGABRT
		{ "SIGABRT",   SIGABRT,   },
#endif
#ifdef SIGEMT
		{ "SIGEMT",    SIGEMT,    },
#endif
#ifdef SIGFPE
		{ "SIGFPE",    SIGFPE,    },
#endif
#ifdef SIGKILL
		{ "SIGKILL",   SIGKILL,   },
#endif
#ifdef SIGBUS
		{ "SIGBUS",    SIGBUS,    },
#endif
#ifdef SIGSEGV
		{ "SIGSEGV",   SIGSEGV,   },
#endif
#ifdef SIGSYS
		{ "SIGSYS",    SIGSYS,    },
#endif
#ifdef SIGPIPE
		{ "SIGPIPE",   SIGPIPE,   },
#endif
#ifdef SIGALRM
		{ "SIGALRM",   SIGALRM,   },
#endif
#ifdef SIGTERM
		{ "SIGTERM",   SIGTERM,   },
#endif
#ifdef SIGURG
		{ "SIGURG",    SIGURG,    },
#endif
#ifdef SIGSTOP
		{ "SIGSTOP",   SIGSTOP,   },
#endif
#ifdef SIGTSTP
		{ "SIGTSTP",   SIGTSTP,   },
#endif
#ifdef SIGCONT
		{ "SIGCONT",   SIGCONT,   },
#endif
#ifdef SIGCHLD
		{ "SIGCHLD",   SIGCHLD,   },
#endif
#ifdef SIGTTIN
		{ "SIGTTIN",   SIGTTIN,   },
#endif
#ifdef SIGTTOU
		{ "SIGTTOU",   SIGTTOU,   },
#endif
#ifdef SIGIO
		{ "SIGIO",     SIGIO,     },
#endif
#ifdef SIGXCPU
		{ "SIGXCPU",   SIGXCPU,   },
#endif
#ifdef SIGXFSZ
		{ "SIGXFSZ",   SIGXFSZ,   },
#endif
#ifdef SIGVTALRM
		{ "SIGVTALRM", SIGVTALRM, },
#endif
#ifdef SIGPROF
		{ "SIGPROF",   SIGPROF,   },
#endif
#ifdef SIGWINCH
		{ "SIGWINCH",  SIGWINCH,  },
#endif
#ifdef SIGINFO
		{ "SIGINFO",   SIGINFO,   },
#endif
#ifdef SIGUSR1
		{ "SIGUSR1",   SIGUSR1,   },
#endif
#ifdef SIGUSR2
		{ "SIGUSR2",   SIGUSR2,   },
#endif
		{  NULL,       0,         },
	};
	int i;

	for (i = 0; signames[i].str != NULL; i++)
		if (sig == signames[i].num)
			return signames[i].str;
	return "unknown signal";
}
