/*
 * $Id$
 *
 * Copyright (c) 2005, 2006 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#include <stdlib.h>
#include <string.h>

#include "log.h"
#include "text.h"
#include "zupsd.h"

RCSID("$Id$");

/*
 * Replaces any occurance of search by replace in a newly allocated copy of buf.
 * The returned buffer must be free(3)d by the caller.  Returns a copy of buf if
 * search or replace are NULL.  Returns NULL on failure.
 */
char *
replace(const char *buf, const char *search, const char *replace)
{
	size_t size, search_len, replace_len;
	int diff, offset;
	char *newbuf, *tmp, *p;

	if ((newbuf = strdup(buf)) == NULL) {
		error("cannot allocate memory: %m");
		return NULL;
	}
	if (search == NULL || replace == NULL)
		return newbuf;

	size = strlen(buf) + 1;
	search_len = strlen(search);
	replace_len = strlen(replace);
	diff = replace_len - search_len;

	debug("replacing %s by %s in %s", search, replace, buf);

	for (p = newbuf; *p != '\0' && (p = strstr(p, search)) != NULL;
	    p = newbuf + offset + replace_len, size += diff) {
		offset = p - newbuf;
		if ((tmp = realloc(newbuf, size + diff)) == NULL) {
			error("cannot reallocate memory: %m");
			free(newbuf);
			return NULL;
		}
		newbuf = tmp;
		/*
		 * We have the old buffer "The answer is foo!" in newbuf and
		 * want to replace "foo" by "fortytwo".  First step is to move
		 * anything following the "foo" (the "!", including the '\0') to
		 * it's new place.  "foo" is located at newbuf + offset, the "!"
		 * at newbuf + offset + search_len.  The new location of "!"
		 * will be at newbuf + offset + replace_len.  The length of "!"
		 * plus '\0' is equal to the size of the old(!) buffer (19),
		 * minus offset (14), minus search_len (3), that is, 2.
		 */
		(void) memmove(newbuf + offset + replace_len,
		    newbuf + offset + search_len,
		    size - offset - search_len);
		/*
		 * Now that we've moved the trailing bytes to the new place, we
		 * can insert the replace string "fortytwo" at newbuf + offset.
		 */
		(void) memcpy(newbuf + offset, replace, replace_len);
	}

	debug("done replacing %s by %s in %s", search, replace, buf);
	return newbuf;
}
