/*
 * $Id$
 *
 * Copyright (c) 2005, 2006, 2007, 2009, 2011 Freie Universitaet Berlin.
 * All rights reserved.
 *
 * Written by Holger Weiss <holger@ZEDAT.FU-Berlin.DE>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ZUPSD_H
#define ZUPSD_H

#if HAVE_CONFIG_H
#include <config.h>
#endif			/* HAVE_CONFIG_H */

#if HAVE_SYS_WAIT
#include <sys/wait.h>
#endif			/* HAVE_SYS_WAIT */

#define ZUPSD_STRING    PACKAGE_STRING
#define COPYRIGHT      "Copyright (c) Freie Universitaet Berlin.  " \
                       "All rights reserved."

#define DEFAULT_CONFFILE  SYSCONFDIR "/zupsd.conf"
#define DEFAULT_HOSTSFILE SYSCONFDIR "/zupsd-hosts"
#define DEFAULT_FACILITY_NAME        "DAEMON"
#define DEFAULT_FACILITY              LOG_DAEMON

/* module return codes */
#define MODULE_OK       0
#define MODULE_UNKNOWN  1
#define MODULE_WARNING  2
#define MODULE_CRITICAL 3
#define MODULE_ALERT    4

/* bool type */
#if HAVE_STDBOOL_H
#include <stdbool.h>
#else
#if !HAVE__BOOL
#ifdef __cplusplus
typedef bool _Bool;
#else
typedef unsigned char _Bool;
#endif			/* __cplusplus */
#endif			/* not HAVE__BOOL */
#define bool _Bool
#define false 0
#define true 1
#define __bool_true_false_are_defined 1
#endif			/* HAVE_STDBOOL_H */

#ifndef __GNUC__
#define __attribute__(x)	/* NOTHING */
#endif

#define UNUSED __attribute__((unused))

#define RCSID(id) static const char rcsid[] UNUSED = id

#ifndef WNOHANG
#define WNOHANG 0100	/* non-blocking wait(2) */
#endif
#ifndef WIFEXITED
#define WIFEXITED(stat)   ((int) ((stat) & 0xFF) == 0)
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(stat) ((int) (((stat) >> 8 ) & 0xFF))
#endif
#ifndef WIFSIGNALED
#define WIFSIGNALED(stat) ((int) ((stat) & 0xFF) > 0 && \
                           (int) ((stat) & 0xFF00) == 0)
#endif
#ifndef WTERMSIG
#define WTERMSIG(stat)    ((int) ((stat) & 0x7F))
#endif

/* library function replacements */
#if !HAVE_SNPRINTF
int snprintf(char *str, size_t count, const char *fmt, ...);
#endif			/* not HAVE_SNPRINTF */
#if !HAVE_STRCASECMP
int strcasecmp(const char *s1, const char *s2);
#endif			/* not HAVE_STRCASECMP */
#if !HAVE_STRNCASECMP
int strncasecmp(const char *s1, const char *s2, size_t n);
#endif			/* not HAVE_STRNCASECMP */

typedef struct {
	const char *str;
	int num;
} map;

static inline const char *
state2str(int state)
{
	static const map states[] = {
		{ "OK",       MODULE_OK,       },
		{ "WARNING",  MODULE_WARNING,  },
		{ "CRITICAL", MODULE_CRITICAL, },
		{ "ALERT",    MODULE_ALERT,    },
		{ "UNKNOWN",  MODULE_UNKNOWN,  },
		{  NULL,      0,               },
	};
	int i;

	for (i = 0; states[i].str != NULL; i++)
		if (state == states[i].num)
			return states[i].str;
	return "unknown state";
}

#endif			/* ZUPSD_H */
